#!/usr/bin/python
#
# Parse LT8910 commands from Scana logic SPI traces (csv export)
#
#  Based upon idea of nRF24_decode.py from victz
# 

# Names derived from contents in datasheet
reg_map = {
3  : "3_RF_SYNTH_LOCK",
6  : "6_RAW_RSSI",
7  : "7_RXTX_CHNL",
9  : "9_PA_CTRL",
10 : "10_OSC_XTAL_EN",
11 : "11_RSSI_PDN",
23 : "23_VCO_CAL_EN",
29 : "29_RF_VER_ID",
32 : "32_AIRFMT",
35 : "35_PWRCONFIG",
36 : "36_SYNCWORD0",
37 : "37_SYNCWORD1",
38 : "38_SYNCWORD2",
39 : "39_SYNCWORD3",
40 : "40_THRESH",
41 : "41_PKTCONF",
43 : "43_RSSI",
44 : "44_DATARATE",
48 : "48_STATUS",
50 : "50_TXRX_FIFO",
52 : "52_TXRX_RWPTRS"
}

def register_name(reg):
    def_name = "REG %d" % reg
    return reg_map.get(reg, def_name)


def dump_command(packet_id, command, status, data_out, data_in, timestamp):
  global bank
  global last_ts
  global first_ts
  global rf_counter
  if packet_id == -1: return
  mnemonic = "UNKNOWN"
  # Check if config register (0-0x2f)
  regnum = command & 0x3f;
  if (command < 0x80):
      mnemonic = "WRITE %s (%02X)" % (register_name(regnum), command)
  else:
      # Confirmed with CG022 trace. Programs THRESH (reg 0x28) to 44 02 and reads these values back with cmd 0xA8
      mnemonic = "READ %s (%02X)" % (register_name(regnum),command)
      
  if len(data_out) == 2:
      mnemonic += " DATA: %02X %02X" % (data_out[0], data_out[1])
      mnemonic += " STATUS: %02X %02X" % (data_in[0], data_in[1])
  elif len(data_out) > 0:
      mnemonic += "\n       DATA:"
      for d in data_out:
          mnemonic += " %02x" % d
      mnemonic += "\n     STATUS:"
      for d in data_in:
          mnemonic += " %02x" % d
    
  print "%3.4f % 3d %s" % (timestamp, packet_id, mnemonic)
  #print " %s" % (mnemonic)


def process_file(f):
    packet_id = -1
    # SPI exchange parameters
    command = -1
    status = -1
    data_out = []
    data_in = []
    timestamp = 0

    count = 0

    for line in f:
        line = line.strip()
        if len(line) == 0 or line[0] == '#': continue
        parts = line.split(',')
        if len(parts) != 4 or parts[1] == 'Packet ID' or parts[1] == '': continue
        
        # Cope with ASCII data, too
        # Note: This seems to be still incomplete
        if parts[2].startswith("0x"):
            dbout = int(parts[2], 16)
        elif len(parts[2]) == 1:
            dbout = ord(parts[2])
        elif parts[2] == "' '":
            dbout = 0x20
        elif parts[2].startswith("'"):
            dbout = int(parts[2].split("'")[1], 10)
        else:
            print "Unhandled format: line %d : part 2 = %s" % (count, parts[2])
            dbout = 0
        if parts[3].startswith("0x"):
            dbin = int(parts[3], 16)
        elif parts[3] == "' '":
            dbin = 0x20
        elif len(parts[3]) == 1:
            dbin = ord(parts[3])
        elif parts[3].startswith("'"):
            dbin = int(parts[3].split("'")[1], 10)
        else:
            print "Unhandled format: line %d : part 3 = %s" % (count, parts[3])
            dbin = 0
        
        if packet_id != int(parts[1]):
            # Skip status requests
            #if command != 0x07:
            dump_command(packet_id, command, status, data_out, data_in, timestamp)
            timestamp = float(parts[0])
            if swap_io == 0:
                command = dbout
                status = dbin
            else:
                command = dbin
                status = dbout
            packet_id = int(parts[1])
            data_out = []
            data_in = []
        else:
            if swap_io == 0:
                data_out.append(dbout)
                data_in.append(dbin)
            else:
                data_out.append(dbin)
                data_in.append(dbout)
        count = count +1
    dump_command(packet_id, command, status, data_out, data_in, timestamp)

def main(argv):
    global swap_io
    f = file(argv[0])
    swap_io = 0
    print_status = 0
    for arg in argv:
        if arg == '--swap':
            print "Swapping MISO and MOSI input"
            swap_io = 1
    
    process_file(f)

if __name__ == '__main__':
    import sys
    main(sys.argv[1:])

