#include "UDI.h"
#include "nRF24L01.h"



void UDI_TX::setTXId(uint8_t txid_[3])
{
  txid[0] = txid_[0];
  txid[1] = txid_[1];
  txid[2] = txid_[2];
}

void UDI_TX::begin()
{
  Serial.print("UDI_TX::begin()\n");
  packet_counter = 0;
  state = 0;
  radio.begin();
  radio.write_register(CONFIG, 0x00); //_BV(EN_CRC) | _BV(CRCO));

  // UDI does Beken stuff FIRST  
  radio.activate(0x53); // magic for BK2421 bank switch
  //Serial.write("Try to switch banks "); Serial.print(radio.read_register(STATUS)); Serial.write("\n");
  if (radio.read_register(STATUS) & 0x80) {
    //Serial.write("BK2421!\n");
    long nul = 0;
    radio.write_register(0x00, (const uint8_t *) "\x40\x4B\x01\xE2", 4); // same as datasheet
    radio.write_register(0x01, (const uint8_t *) "\xC0\x4B\x00\x00", 4); // same as datasheet
    radio.write_register(0x02, (const uint8_t *) "\xD0\xFC\x8C\x02", 4); // same as datasheet
    radio.write_register(0x03, (const uint8_t *) "\x99\x00\x39\x41", 4); // UDI differs from V2x2 (99 00 39 41 IS given in datasheet)
    radio.write_register(0x04, (const uint8_t *) "\xD9\x9E\x86\x0B", 4); // UDI differs - single carrier mode (still differ from D9 9E 86 21 as given in datasheet)
    radio.write_register(0x05, (const uint8_t *) "\x24\x06\x7F\xA6", 4); // Disable RSSI
    radio.write_register(0x0C, (const uint8_t *) "\x00\x12\x73\x05", 4); // datasheet says 0x00731200 - 05 vs 00 !
    radio.write_register(0x0D, (const uint8_t *) "\x36\xB4\x80\x00", 4); // datasheet says 0x0080B436  - same !
    radio.write_register(0x0E, (const uint8_t *) "\x41\x10\x04\x82\x20\x08\x08\xF2\x7D\xEF\xFF", 11); // Ramp curve, differs from datasheet
  }
  radio.activate(0x53); // switch bank back
  
  radio.write_register(CONFIG, 0x78);     // IRQs disabled, CRC enabled, PWR down, TX mode
  radio.write_register(EN_AA, 0x3F);      // Enable auto acknowledge for data pipe 0 .. 5
  radio.write_register(EN_RXADDR, 0x01);  // Enable data Pipe 0
  radio.write_register(SETUP_AW, 0x01);   // Address is 3 bytes (see RX_ADDR_Pn and TX_ADDR below)
  radio.write_register(SETUP_RETR, 0x3A); // retransmitt after 1000us, 10 times
//  radio.write_register(RF_CH, 0x08);    // Set on bind
  radio.write_register(RF_SETUP, 0x27); // 0dbm, 250kbs
  radio.write_register(STATUS, 0x70);
  radio.write_register(RX_PW_P0, 0x07); // 7 bytes payload
  radio.write_register(FEATURE, 0x00);  // constant payload length, no ack payload, disable tx_payload_noack
  radio.flush_tx();
  radio.flush_rx();
  radio.write_register(CONFIG, 0x7A);    // Radio enable (TX)
  // Init done for UDI  
  
  // NOTE RF Channel and Address set when bind starts ...

  radio.ce(HIGH); // THIS ONE ENABLES Radio

  state = INITIALIZED;
  packet_sent = false;
  
}

#define MAX_RETRIES 256
void UDI_TX::update()
{
  uint8_t buf[7];
  int radio_status = 0;

  if (state < BIND0) return;
  radio_status = radio.read_register(STATUS);
  
  // Wait for auto ack of sent packet or max retries ...
  if (packet_sent) {
    int retries = MAX_RETRIES;
    while (retries-- && (0 == (radio_status & 0x30))) {
      radio_status = radio.read_register(STATUS);
    }
    if (!retries) {
      Serial.print("No Auto-ACK received and max retries not reached!\n");
    }
    Serial.print(" Status ");Serial.print(radio_status,HEX);Serial.print(" after ");Serial.print(MAX_RETRIES-retries);Serial.print(" tries\n");
  }
  int cd = radio.read_register(CD);
  if (cd) Serial.print("Carrier detected!\n");
  
  if (radio_status & 0x40) {
    Serial.print("Data received, status ");
    Serial.print(radio_status,HEX);
    Serial.print("\n");
  }
 
  //Serial.print(" Carrier Detect: "); Serial.print(radio.read_register(CD)); Serial.print("\n");
  
  packet_sent = false;
  
  // Now CE is set to low when sending data
 // if ((state != BIND1)&&(state != BIND3)&&(state != LISTENING))
 
  
/*  
  Serial.print(" STATUS: ");
  Serial.print(radio_status,HEX);
  Serial.print(" ctr: ");
  Serial.print(packet_counter);
  Serial.print("\n");
*/
  radio.write_register(STATUS, 0x7F); // clear MAX_RT, TX_DS and RX_DR
  radio.ce(LOW); // Turn off radio

  switch (state) {
    case INITIALIZED:
      return;
      
    case BIND0:
      // start_bind
      // send TX ID (x ?)
      buf[0] = 0x5A;
      buf[1] = txid[0];
      buf[2] = txid[1];
      buf[3] = txid[2];
      buf[4] = 0x00;
      buf[5] = 0x00;
      buf[6] = 0x00;
      radio.flush_tx();
      radio.write_payload(buf, 7);
      
      radio.ce(HIGH); // Turn on radio

      packet_sent = true;
      packet_counter++;
      if (packet_counter > 8) {
        state = BIND1;
        packet_counter = 0;
        // start listening
        // NOTE: THIS IS DONE ONE NEXT TIMER EVENT !       
        
//        radio.startListening();
        //radio.write_register(CONFIG, 0x79); // Power down - needed to switch from TX to RX (other way would be CE pin)
        //Serial.write("BIND1: Power down\n");
      }
      break;      

    case BIND1:
     // CONFIG = 0x7B (radio enable, RX)  
     // receive RX ID (x 2)
     if (packet_counter == 0) {
        // Power up, start listening
        Serial.write("BIND1: Start listening\n"); // NOTE: This does NOT happen on multiple of 20ms. Its 10ms BEFORE receive, but ONLY 2ms AFTER last send (!)
        // THIS IS EXACTLY WHAT ORIGINAL TX DOES
        radio.write_register(STATUS,0x70);  // 27 70
        radio.flush_rx();                   // E2
        radio.write_register(CONFIG, 0x7B); // 20 7B : RX enable
        //radio.ce(HIGH);                     // CONFIRMED TO HAPPEN ON REAL TX RIGHT AFTER ENABLING RX MODE, RIGHT AFTER RX ENABLE. NEXT COMES READ STATUS
                                            // NOTE: REAL RADIO _ALWAYS_ SETS CE TO HIGH AFTER TRANSFER AND TO LOW AFTER READING STATUS - WHEN IN SEND MODE

        radio.ce(HIGH); // Turn on radio
        packet_counter++;
        break;
     }
     
     if (radio_status & 0x40) { // Data available
       // You HAVE TO bring CE to low to READ RX FIFO, too !!!!
     
       radio.read_payload(buf, 7);
       Serial.print("BIND1: Received ");
       for (int i=0; i<7; i++) {
         Serial.print(buf[i],HEX);
         Serial.print(" ");
       }
       Serial.print("\n");
       if (buf[0] != 0xA5) {
         Serial.print(" BAD PREAMBLE !\n");
         packet_counter++;
         return;
       }
       if (packet_counter == 0) {
         rxid[0] = buf[1];
         rxid[1] = buf[2];
         rxid[2] = buf[3];
       } else {
         if (rxid[0] != buf[1] ||
             rxid[1] != buf[2] ||
             rxid[2] != buf[3]) {
               Serial.print(" RX ID MISMATCH !\n");
             }
       }
     }
     packet_counter++;
//     if (packet_counter >= 4) {
     if (packet_counter >= 40) { // DEBUG: Give it some time
       //radio.stopListening();
       radio.write_register(CONFIG, 0x7A); // TX enable       
       packet_counter = 0;
       // Ensure we have valid Receiver ID
       if (!rxid[0] && !rxid[1] && !rxid[2]) {
         Serial.print(" NO RX ID - Stopping bind!\n");
         state = INITIALIZED;
         return;
       }
       // Okay, acknowledge the ID
       radio.ce(HIGH); // Turn on radio
       state = BIND2;
       Serial.print("BOUND2: Sending ID ACK\n");
     }
     break;     
  
   case BIND2:
     // send ACK RX ID (x 3)
      buf[0] = 0xAA;
      buf[1] = rxid[0];
      buf[2] = rxid[1];
      buf[3] = rxid[2];
      buf[4] = rxid[0];
      buf[5] = rxid[1];
      buf[6] = rxid[2];
      radio.flush_tx();
      radio.write_payload(buf, 7);
      packet_sent = true;
      packet_counter++;
      if (packet_counter > 3) {
        state = BIND3;
        packet_counter = 0;
        // start listening
        radio.write_register(CONFIG, 0x7B); // RX enable
        //radio.startListening();
        Serial.print("BIND3: Starting listening\n");
      }
      radio.ce(HIGH); // Turn on radio
      break;      
    
    case BIND3:
     // receive ACK (x 4)
     if (radio_status & 0x40) { // Data available
       // You HAVE TO bring CE to low to READ RX FIFO, too !!!!

       radio.read_payload(buf, 7);
       Serial.print("BIND3: Received ");
       for (int i=0; i<7; i++) {
         Serial.print(buf[i],HEX);
         Serial.print(" ");
       }
       Serial.print("\n");
       if (buf[0] != 0xDD) {
         Serial.print(" BAD PREAMBLE !\n");
         packet_counter++;
         return;
       }
       if (rxid[0] != buf[1] ||
           rxid[1] != buf[2] ||
           rxid[2] != buf[3]) {
             Serial.print(" RX ID MISMATCH !\n");
       }
     }
     packet_counter++;
     if (packet_counter >= 5) {
       radio.stopListening();
       //radio.write_register(CONFIG, 0x7A); // TX enable
       packet_counter = 0;
       // Okay, switch address
       state = BOUND0;
       uint8_t rx_tx_addr[5];
       rx_tx_addr[0] = rxid[2]; // NOTE: Byte Order inverted !
       rx_tx_addr[1] = rxid[1];
       rx_tx_addr[2] = rxid[0];
       rx_tx_addr[3] = 0xE7;
       rx_tx_addr[4] = 0xE7;
       radio.write_register(RX_ADDR_P0, rx_tx_addr, 5);
       radio.write_register(TX_ADDR, rx_tx_addr, 5);       
       Serial.print("BOUND0: Switched Address\n");
     }
     radio.ce(HIGH); // Turn on radio
     break;
     
    case LISTENING:
     if ((radio_status & 0x4E) != 0x0E) { // Data available
       Serial.print("Status:  ");
       Serial.print(radio.read_register(STATUS),HEX);
       Serial.print("\n");
       radio.read_payload(buf, 7);
       Serial.print("LISTENING: Received ");
       for (int i=0; i<7; i++) {
         Serial.print(buf[i],HEX);
         Serial.print(" ");
       }
       Serial.print("\n");
       radio.ce(HIGH); // Turn on radio
     }
     break;
     
    default:
      Serial.print("Unexpected state: ");
      Serial.print(state);
      Serial.print("\n");
      break;
  }
  
  // Allow receiving
  radio.ce(HIGH);
  
  radio.read_register(STATUS); // THIS IS DONE on REAL TX

  
  // THESE ARE HANDLED IN command() !
  // bound  
  // send data x 6
  
  // switch channel
  // send data x N
  
}

void UDI_TX::start_bind()
{
  if ((state >= BIND0)&&(state < LISTENING)) return;
  if (state == LISTENING) {
    //radio.stopListening();
    radio.write_register(CONFIG, 0x7A); // TX enable
  }
  radio.ce(LOW);
  // Set RX/TX Address to UDI bind address
  // and RF Channel to 00
  radio.write_register(STATUS, 0x70);
  const uint8_t* rx_tx_addr = reinterpret_cast<const uint8_t *>("\xE7\x7E\xE7\xE7\xE7"); // UDI bind Address
  radio.write_register(RX_ADDR_P0, rx_tx_addr, 5);
  radio.write_register(TX_ADDR, rx_tx_addr, 5);
  radio.write_register(RF_CH, 0x00);
  
  rxid[0]=rxid[1]=rxid[2]=0; // Clear receiver ID
  state = BIND0;
  packet_counter = 0;

  radio.ce(HIGH); // Turn on radio
  
  Serial.print("BIND0: Sending TX ID\n");
}


void UDI_TX::start_listen()
{
  if (state > INITIALIZED) return;
  radio.ce(LOW);
  radio.write_register(STATUS, 0x70);
  const uint8_t* rx_tx_addr = reinterpret_cast<const uint8_t *>("\xE7\x7E\xE7\xE7\xE7"); // UDI bind Address
  radio.write_register(RX_ADDR_P0, rx_tx_addr, 5);
  radio.write_register(TX_ADDR, rx_tx_addr, 5);
  radio.write_register(RF_CH, 0x00);
  radio.write_register(CONFIG, 0x7B); // RX enable
  radio.ce(HIGH);
  //radio.startListening();
  state = LISTENING;
  Serial.print("LISTENING\n");
}


void UDI_TX::start_receiving()
{
  if (state > INITIALIZED) return;
  radio.ce(LOW);
  radio.write_register(STATUS, 0x70);
  const uint8_t* rx_tx_addr = reinterpret_cast<const uint8_t *>("\xE7\x7E\xE7\xE7\xE7"); // UDI bind Address
  const uint8_t* rx_tx_addr2 = reinterpret_cast<const uint8_t *>("\x7E\xE7\x7E\xE7\xE7"); // reversed UDI bind Address
  radio.write_register(RX_ADDR_P0, rx_tx_addr2, 5);
  radio.write_register(RX_ADDR_P1, rx_tx_addr, 5);
  radio.write_register(TX_ADDR, rx_tx_addr, 5);
  radio.write_register(RF_CH, 0x00);
  radio.write_register(CONFIG, 0x7B); // RX enable
  radio.ce(HIGH);
  state = RECEIVER;
  Serial.print("RECEIVING\n");
}



bool UDI_TX::isBound() {
  return (state >= BOUND0);
}


void UDI_TX::command(uint8_t throttle, int8_t yaw, int8_t pitch, int8_t roll, uint8_t flags)
{
  if (state < BOUND0) {
    Serial.print("Command called in bad state: ");
    Serial.print(state);
    Serial.print("\n");
    return;
  }
  int radio_status;
  int retries = MAX_RETRIES;

  radio_status = radio.read_register(STATUS);
  // Wait for auto ack of sent packet or max retries ...
  while (packet_sent && retries-- && (0 == (radio_status & (_BV(TX_DS) |(_BV(MAX_RT)))))) {
    radio_status = radio.read_register(STATUS);
  }
  if (!retries) {
    Serial.print("No Auto-ACK received and max retries reached!\n");
  }
  packet_sent = false;

  radio.ce(LOW);
  radio.write_register(STATUS, 0x70); // clear MAX_RT

  uint8_t buf[7];
  buf[0] = 0x55;
  buf[1] = throttle;
  buf[2] = (uint8_t) yaw;
  buf[3] = (uint8_t) pitch;
  buf[4] = (uint8_t) roll;
  buf[5] = 0x20;
  buf[6] = 0x20;
  radio.flush_tx();
  radio.write_payload(buf, 7);
  packet_sent = true;
  packet_counter++;
  if ((state == BOUND0)&&(packet_counter > 6)) {
    packet_counter=0;
    radio.write_register(RF_CH, 0x07); // NOTE: This is 07 on first try, then 23, ... 
    // channel sequence is 07 23 4F 0E 3D 14 2C 46 1C 34 (only changed unless Bind ACK is received - then it switches to NEXT channel and KEEPS THERE !)
    state = BOUND;
  }
  
  radio.ce(HIGH);
  radio_status = radio.read_register(STATUS);
}

