#include "Arduino.h"

class nRF24;
class UDI_TX {
  nRF24& radio;
  uint8_t txid[3];
  uint8_t rxid[3];
  bool packet_sent;
  int packet_counter;
  int state;
public:

// States of TX
enum { STARTING = 0, // pre init
       INITIALIZED,  // RF Init done
       BIND0,        // Sending Bind packets (RF Channel 00 with bind Address E7 7E E7)
       BIND1,        // Awaiting RX ID
       BIND2,        // Sending RX ID Ack
       BIND3,        // Awaiting Ack
       BOUND0,       // Sending payload on RF channel 00 with RX Address
       BOUND,        // Sending payload on RF channel XX with RX Address
       LISTENING,    // DEBUG: Listen on incoming messages, RF CH 00, bind addr E7 7E E7
       RECEIVER      // We play receiver ...
     };

  UDI_TX(nRF24& radio_) :
    radio(radio_)
  {}
  bool isBound();
  int getState() { return state; }
  void setTXId(uint8_t txid_[3]);
  void begin();
  void update();
  void start_bind();
  void start_listen();
  void start_receiving();
  void command(uint8_t throttle, int8_t yaw, int8_t pitch, int8_t roll, uint8_t flags);
};

