#include <SPI.h>
#include "nRF24L01.h"
#include "UDI.h"

// NOTE: ATMega2560
#define CE_PIN 49
// was 9
#define CSN_PIN 48
// was 10

// Pins for AATMega2560:
//  48 = CSN, 49 = CE, 50 = MISO, 51 = MOSI, 52 = SCK

#define DEBUG_PRINT


//uint8_t txid[3] = { 0x19, 0xca, 0xf6 }; // -> observed with broken U818A (RX ID e.g. F9 18 39)
uint8_t txid[3] = { 0x25, 0xca, 0x5a };  // U818A TX

#define USE_TIMER_INTERRUPTS


#ifdef USE_TIMER_INTERRUPTS
#include <avr/io.h>
#include <avr/interrupt.h>
#endif

nRF24 radio(CE_PIN, CSN_PIN);
UDI_TX tx(radio);

uint8_t throttle, flags;
int8_t yaw, pitch, roll;

int a0, a1, a2, a3;
int a0min, a0max;
int a1min, a1max;
int a2min, a2max;
int a3min, a3max;

void calibrate()
{
  a0min = 150; a0max=600;
  a1min = 150; a0max=600;
  a2min = 150; a0max=600;
  a3min = 150; a0max=600;
}

void initInput()
{
  pinMode(A0, INPUT);
  pinMode(A1, INPUT);
  pinMode(A2, INPUT);
  pinMode(A3, INPUT);
  calibrate();
}

bool readInput()
{
  bool changed = false;
  long a;
  a = analogRead(A0);
  if (a < a0min) a0min = a;
  if (a > a0max) a0max = a;
  a = (a-a0min)*255/(a0max-a0min);
  if (a != a0) { changed = true; a0 = a; }

  a = analogRead(A1);
  if (a < a1min) a1min = a;
  if (a > a1max) a1max = a;
  a = (a-a1min)*255/(a1max-a1min);
  if (a != a1) { /*changed = true;*/ a1 = a; }

  a = analogRead(A2);
  if (a < a2min) a2min = a;
  if (a > a2max) a2max = a;
  a = (a2max-a)*255/(a2max-a2min);
  if (a != a2) { /*changed = true;*/ a2 = a; }

  a = analogRead(A3);
  if (a < a3min) a3min = a;
  if (a > a3max) a3max = a;
  a = (a3max-a)*255/(a3max-a3min);
  if (a != a3) { /*changed = true;*/ a3 = a; }
  return changed;
}


int counter = 0;
int direction = 1;
int lastmillis = 0;
int bind = 0;
bool calibrated = false;


void setup() 
{
  initInput();
  readInput();
  Serial.begin(115200);
  Serial.print("Starting up ...\n");
  tx.setTXId(txid);  
  tx.begin();
  throttle = 0; yaw = 0; pitch = 0; roll = 0; flags = 0;
  counter = 0;
  direction = 8;
  bind = 0;
/*
  Serial.write("Reading status\n");
  uint8_t res = radio.read_register(STATUS);
  Serial.write("Result: ");
  Serial.print(res);
  Serial.write("\n");
*/

#ifdef USE_TIMER_INTERRUPTS
#define RESOLUTION 65536
  unsigned char clockSelectBits;
  long microseconds = 20000; // 20 ms
  // That's simply copied from "TimerOne" library
  TCCR1A = 0;
  TCCR1B = _BV(WGM13);
  long cycles = (F_CPU * microseconds) / 2000000;                                // the counter runs backwards after TOP, interrupt is at BOTTOM so divide microseconds by 2
  if(cycles < RESOLUTION)              clockSelectBits = _BV(CS10);              // no prescale, full xtal
  else if((cycles >>= 3) < RESOLUTION) clockSelectBits = _BV(CS11);              // prescale by /8
  else if((cycles >>= 3) < RESOLUTION) clockSelectBits = _BV(CS11) | _BV(CS10);  // prescale by /64
  else if((cycles >>= 2) < RESOLUTION) clockSelectBits = _BV(CS12);              // prescale by /256
  else if((cycles >>= 2) < RESOLUTION) clockSelectBits = _BV(CS12) | _BV(CS10);  // prescale by /1024
  else        cycles = RESOLUTION - 1, clockSelectBits = _BV(CS12) | _BV(CS10);  // request was out of bounds, set as maximum
  ICR1 = cycles;                                                                 // ICR1 is TOP in p & f correct pwm mode
  TCCR1B &= ~(_BV(CS10) | _BV(CS11) | _BV(CS12));
  TIMSK1 = _BV(TOIE1);                                     // sets the timer overflow interrupt enable bit
  sei();                                                   // ensures that interrupts are globally enabled  
  TCCR1B |= clockSelectBits;                                                     // reset clock select register (-> starts timer)
#endif
} 



void loop() 
{
#ifdef USE_TIMER_INTERRUPTS
}

// interrupt service routine
ISR(TIMER1_OVF_vect)
{
#endif
  
  bool changed = readInput();
#if 0
  if (changed) {
    Serial.print(" A0: ");
    Serial.print(a0,HEX);
    Serial.print(" A1: ");
    Serial.print(a1,HEX);
    Serial.print(" A2: ");
    Serial.print(a2,HEX);
    Serial.print(" A3: ");
    Serial.print(a3,HEX);
    Serial.print("\n");
  }
#endif
  if (bind == 0) {
    a0 = a1 = a2 = a3 = 0; // zero channels on bind
    throttle = a0;
    flags = 0xc0;
#if 1
    /* Auto bind in 2.5 sec after turning on */
    counter += direction;
    if (direction > 0) {
      if (counter > 256) direction = -8;
    } else {
      if (counter < 0) {
        direction = 1;
        counter = 0;
        bind = 1;
        flags = 0;
      }
    }
#else
    if (direction > 0) {
      if (throttle >= 255) direction = -1;
    } else {
      if (throttle == 0) {
        direction = 1;
        counter = 0;
        bind = 1;
        flags = 0;
        /*
        Serial.write("Bound\n");
        Serial.write("a0min "); Serial.print(a0min);
        Serial.write(" a0max "); Serial.print(a0max);
        Serial.write("\na1min "); Serial.print(a1min);
        Serial.write(" a1max "); Serial.print(a1max);
        Serial.write("\na2min "); Serial.print(a2min);
        Serial.write(" a2max "); Serial.print(a2max);
        Serial.write("\na3min "); Serial.print(a3min);
        Serial.write(" a3max "); Serial.print(a3max);
        */
      }
    }
#endif    
  } else {
    a0 = counter;
    a1 = 0xde;
    a2 = 0xad;
    a3 = 0xbf;
    
    throttle = a0;
    yaw = a1 < 0x80 ? 0x7f - a1 : a1;
    roll = a2 < 0x80 ? 0x7f - a2 : a2 ;
    pitch = a3 < 0x80 ? 0x7f - a3 : a3;

    // Blinking LED lights
    counter += direction;
    if (direction > 0) {
      if (counter > 255) {
        direction = -1;
        counter = 255;
        flags = 0x10;
//        Serial.write("LED on\n");
      }
    } else {
      if (counter < 0) {
        direction = 1;
        counter = 0;
        flags = 0x00;
//        Serial.write("LED off\n");
      }
    }
    //
  }
  
  if (bind == 1) {
    tx.start_bind();
    bind = 2;
  }
  if (tx.isBound()) tx.command(throttle, yaw, pitch, roll, flags);
  else tx.update();
  
  // Allow re-bind
  if ((bind == 2) && ((tx.getState() == UDI_TX::INITIALIZED)||(tx.getState() == UDI_TX::LISTENING)) && (Serial.available())) {
    char c = toupper(Serial.read());
    if (c == 'B') {
      Serial.print("Re-Bind\n");
      tx.start_bind();
    }
    if (c == 'L') {
      Serial.print("Listening\n");
      tx.start_listen();
    }
  }
  
  // 20 ms between packets ...
#ifndef USE_TIMER_INTERRUPTS
//  delayMicroseconds(20000); 
  delay(20); // 20ms usually, 10ms when waiting for reply
//  delay(4);
#endif
}

