// Telemetry sensor hub test code

typedef struct {
  uint8_t id;
  uint16_t data;
} Data ;

// sample data from the sensor hub protocol document
Data frame1_sample_data[] = {
  {0x24, 0x0004},	// Acc-x, 0.064g
  {0x25, 0xffc2},	// Acc-y, -1g
  {0x26, 0xfffa},	// Acc-z, -0.1
  {0x10, 0x0064},	// Vario Altitude, 100 meters
  {0x21, 0x0032},	// Vario Altitude, +.5 meters
  {0x02, 0xFFF0},	// Temperature1, -16°C
  {0x05, 0x0050},	// Temperature2, 80°C
  {0x06, 0x5E07},	// Cell 1, 3.8V
  {0x06, 0x3418},	// Cell 2, 4.2V
  {0x06, 0x3A27},	// Cell 3, 3.7V
  {0x06, 0x5D38},	// Cell 4, 4.3V
  {0x28, 0x0200},	// Current, 52.2A
  {0x3a, 0x0050},	// Voltage (amp sensor) 40V
  {0x3b, 0x0050},	// Voltage (amp sensor) +.40 volts 
  {0x03, 0x0023},	// RPM, 2100 RPM
  NULL
} ;

Data frame2_sample_data[] =  {
  {0x14, 0x0140},	// Course, 320°
  {0x1c, 0x0016},	// Course, +.25°
  {0x13, 0x0db4},	// Lattitude: 35° 8'
  {0x1b, 0x1f54},	// Latitide: +.8020'
  {0x23, 0x004e},	// Latitude N
  {0x12, 0x2600},	// Longitude:  97° 26'
  {0x1a, 0x10f4},	// Longitude:  +.4340'
  {0x22, 0x0057},	// Longitude: W
  {0x11, 0x0011},	// Speed: 17 knots
  {0x19, 0x0031},	// Speed: +.49 knots (≅ 9 meters/second or 32.4 km/hour)
  {0x01, 0x06ad},	// GPS Altitude: 1709 meters
  {0x09, 0x0022},	// GPS Altitude: +.34 meters
  {0x04, 0x004B},	// Fuel level: 75
  NULL
} ;

Data frame3_sample_data[] = {
  {0x15, 0x070f},	// Date: ...-07-15
  {0x16, 0x0b00},	// Date: 2011-
  {0x17, 0x1206},	// Time: 06:18
  {0x18, 0x0032},	// Time: ..:..:50
  NULL
} ;

void FrSky_setup(), FrSky_start_frame(), FrSky_send_data(uint8_t, uint16_t);
void SendValue(uint8_t, uint16_t);

void FrSky_send_block(Data *data) {
  FrSky_start_frame() ;
  while (data->id) {
    FrSky_send_data(data->id, data->data);
    data += 1;
  }
}

void setup() {
  FrSky_setup();
  Serial.begin(115200);
}

void loop() {
  unsigned long now;

  FrSky_start_frame();
  FrSky_send_block(frame1_sample_data);
  delay(200);

  FrSky_start_frame();
  FrSky_send_block(frame2_sample_data);
  delay(200);

  FrSky_start_frame();
  FrSky_send_block(frame3_sample_data);
  delay(200);
}
